package com.hipaaspace.webservices;

import com.hipaaspace.webservices.stub.*;

public class JavaWebServicesExample
{
	//public final static String SecurityToken = "PUT YOUR SECURITY TOKEN HERE";
	public final static String SecurityToken = "3932f3b0-cfab-11dc-95ff-0800200c9a663932f3b0-cfab-11dc-95ff-0800200c9a66"; //This is a test SecurityToken
	
	private static void printWebServiceResult(WebServiceResult Result)
	{
		System.out.println("Key: " + Result.getKey());
		System.out.println("Type: " + Result.getKey());
		System.out.println("Properties:");
		Pair[] properties = Result.getResultSet().getPair();
		for (int propertyIndex = 0; propertyIndex < properties.length; ++propertyIndex)
		{
			if (properties[propertyIndex].getValue() != "")
			{
				System.out.println("\t" + properties[propertyIndex].getName() + ": " +
						properties[propertyIndex].getValue());
			}
		}
	}	
	
	private static void testQueryMethods() throws Exception
	{		
		WspHVLookup HIPAASpaceWS = new WspHVLookup_Impl();
		WspHVLookupSoap SOAPReq = HIPAASpaceWS.getWspHVLookupSoap();			
		QueryResponse Response = SOAPReq.query("NPI", "No Name", SecurityToken);
		
		WebServiceResult[] Results = Response.getQueryResult().getWebServiceResult();
		String Error = Response.getError();
		
		if (Error == null)
		{
			String TestKey = null;
			//Request was performed successfully
			for (int index = 0; index < Results.length; ++index)
			{
				if (index == 0)
				{
					//Let's remember the Key of the first item to retrieve detailed information about it later
					TestKey = Results[index].getKey();
				}
				printWebServiceResult(Results[index]);
			}
			
			if (TestKey != null)
			{
				QueryItemResponse ResponseItem = SOAPReq.queryItem("NPI", TestKey, SecurityToken);
				Error = ResponseItem.getError();
				if (Error == null)
				{
					System.out.println("==================== Single Item ====================");
					printWebServiceResult(ResponseItem.getQueryItemResult());
				}
				else
				{
					System.out.println(Error);
				}
			}
		}
		else
		{
			System.out.println(Error);				
		}		
	}

	// This method demonstrates how the NPI query results may be explicitly filtered by the specific
	// fields known prior to the search
	private static void testQueryNPIFiltered() throws Exception
	{
		WspHVLookup HIPAASpaceWS = new WspHVLookup_Impl();
		WspHVLookupSoap SOAPReq = HIPAASpaceWS.getWspHVLookupSoap();	
		
		// Fields used to filter results
		QueryField [] filterFields = new QueryField[1]; 
		filterFields[0] = new QueryField(NPIFields.IndividualOrganizationCode, "Organization", true);
		
		QueryNPIFilteredResponse response = SOAPReq.queryNPIFiltered("Dental San-Diego", new ArrayOfQueryField(filterFields), SecurityToken);
		
		WebServiceResult[] Results = response.getQueryNPIFilteredResult().getWebServiceResult();
		String Error = response.getError();
		
		if (Error == null)
		{
			//Request was performed successfully
			for (int index = 0; index < Results.length; ++index)
			{
				printWebServiceResult(Results[index]);
			}
		}
		else
		{
			System.out.println(Error);				
		}		
	}
	
	// This method validates the NPI profile parameters against the same information
	// stored in the database. Used on the validation forms when user enters his NPI number
	// and additional verification parameters such as - address, name, etc.
	private static void testValidateNPIMethod() throws Exception
	{
		WspHVLookup HIPAASpaceWS = new WspHVLookup_Impl();
		WspHVLookupSoap SOAPReq = HIPAASpaceWS.getWspHVLookupSoap();			
		
		// Fields used for validation against DB information
		QueryField [] validationFields = new QueryField[2]; 
		validationFields[0] = new QueryField(NPIFields.IndividualOrganizationCode, "Organization", true);
		validationFields[1] = new QueryField(NPIFields.State, "TX", true);
		
		ValidateNPIResponse response = SOAPReq.validateNPI("1104828904", new ArrayOfQueryField(validationFields), SecurityToken);
		if (response.isValidateNPIResult())
		{
			System.out.println("Values supplied with Validation Fields match to the NPI profile");		
		}
		else
		{
			System.out.println("Values supplied with Validation Fields do not match to the NPI profile");
		}
	}	
	
	public static void main(String argv[])
	{
		try
		{
			System.out.println("**** Testing Query Methods *****\n\n");
			testQueryMethods();
			System.out.println("\n\n\n**** Testing Validate NPI Methods *****\n\n");
			testValidateNPIMethod();
			System.out.println("\n\n\n**** Testing Query NPI Filtered Methods *****\n\n");
			testQueryNPIFiltered();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
}
