﻿/// This example demostrates the QueryNPI method, that allows to query NPI database in an SQL-like manner.
/// You can specify exact field names that are part of the query. All fields are OR-ed, so if any matches, 
/// corresponding result will be included into the collection
namespace CSharpWebServicesExample
{
	using System;
	using System.Collections.Generic;
	using System.Text;
	
	public class QueryNpiExample
	{
		public void Execute()
		{
			// Creating WebService wrapper object
			HIPAASpace.wspHVLookup wsHIPAASpace = new HIPAASpace.wspHVLookup();

			// Setting initial value of Error to null 
			string error = null;

			// Performing the query call for NPI information. Page Number is 1-based
			HIPAASpace.WebServiceResult[] results = wsHIPAASpace.QueryNPI(
				new HIPAASpace.QueryField[] 
				{	
					new HIPAASpace.QueryField() { Field = HIPAASpace.NPIFields.LastName, ComparisonValue = "CHEN", IsExactMatch = true },
					new HIPAASpace.QueryField() { Field = HIPAASpace.NPIFields.FirstName, ComparisonValue = "EMILY", IsExactMatch = false },
				}, 
				1,
				10,
				Common.SecurityToken, 
				out error);

			foreach (HIPAASpace.WebServiceResult resultItem in results)
			{
				Common.PrintWebServiceResult(resultItem);
			}
		}
	}
}
