﻿/// Example demonstrates free-form search, where you can type a custom text and expect best matches,
/// utilizing the proprietary search mechanisms
namespace CSharpWebServicesExample
{
	using System;
	using System.Collections.Generic;
	using System.Text;
	
	public class GenericQueryExample
	{
		public void Execute()
		{
			// Creating WebService wrapper object
			HIPAASpace.wspHVLookup wsHIPAASpace = new HIPAASpace.wspHVLookup();

			// Setting initial value of Error to null 
			string error = null;

			// Performing the query call
			HIPAASpace.WebServiceResult[] results = wsHIPAASpace.Query("NPI", "Jack Anderson", Common.SecurityToken, out error);

			// Request was performed successfully
			if (error == null)
			{
				string testKey = null;
								
				for (int index = 0; index < results.Length; ++index)
				{
					if (index == 0)
					{
						// Let's remember the Key of the first item to retrieve detailed information about it later
						testKey = results[index].Key;
					}

					Common.PrintWebServiceResult(results[index]);
				}

				if (testKey != null)
				{
					HIPAASpace.WebServiceResult singleResult = wsHIPAASpace.QueryItem("NPI", testKey, Common.SecurityToken, out error);
					if (error == null)
					{
						System.Console.WriteLine("==================== Single Item ====================");
						Common.PrintWebServiceResult(singleResult);
					}
					else
					{
						System.Console.WriteLine(error);
					}
				}
			}
			else
			{
				System.Console.WriteLine(error);
			}
		}
	}
}
