﻿namespace CSharpWebServicesExample
{
	using System;
	using System.Collections.Generic;
	using System.Text;

	/// <summary>
	/// Contains common functionality and string constants
	/// </summary>
	public class Common
	{
		/// <summary>
		/// Security token, identifying specific customer profile
		/// </summary>
		public static string SecurityToken = "3932f3b0-cfab-11dc-95ff-0800200c9a663932f3b0-cfab-11dc-95ff-0800200c9a66"; //This is a test SecurityToken

		/// <summary>
		/// Prints out an individual Web Service result
		/// </summary>
		/// <param name="result">Web Service result value</param>
		public static void PrintWebServiceResult(HIPAASpace.WebServiceResult result)
		{
			System.Console.WriteLine("Key: " + result.Key);
			System.Console.WriteLine("Type: " + result.Type);
			System.Console.WriteLine("Properties:");
			for (int propertyIndex = 0; propertyIndex < result.ResultSet.Length; ++propertyIndex)
			{
				if (result.ResultSet[propertyIndex].Value != string.Empty)
				{
					System.Console.WriteLine("\t" + result.ResultSet[propertyIndex].Name + ": " +
						result.ResultSet[propertyIndex].Value);
				}
			}
		}
	}
}
