﻿//-----------------------------------------------------------------------
// <copyright file="Program.cs" company="HIPAASpace">
//     Copyright (c) HIPAASpace. All rights reserved.
// </copyright>
//-----------------------------------------------------------------------

namespace Epure.Examples.CSharpEINVerification
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Net;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// Current class demonstrates connectivity with HIPAASpace EIN Verification Web API
    /// </summary>
    class Program
    {
        private const string TestSearchQuery = "Microsoft";
        private const string TestEIN = "911144442";
        private const string InvalidEIN = "11111";

        // PLACE YOUR SECURITY TOKEN HERE
        private const string Token = "3932f3b0-cfab-11dc-95ff-0800200c9a663932f3b0-cfab-11dc-95ff-0800200c9a66";

        private static string EINSearchREST = "http://www.HIPAASpace.com/api/ein/search?q={0}&rt=xml&token=" + Token;
        private static string EINCodeREST = "http://www.HIPAASpace.com/api/ein/getcode?q={0}&rt=xml&token=" + Token;
        private static string EINVerifyREST = "http://www.HIPAASpace.com/api/ein/verify?q={0}&rt=xml&token=" + Token;

        static void Main(string[] args)
        {
            WebClient client = new WebClient();

            // Searching EIN by the free form text
            Console.WriteLine("Performing EIN search against the free-form search string \"" + TestSearchQuery + "\"...");
            string response = client.DownloadString(string.Format(EINSearchREST, TestSearchQuery));
            Console.WriteLine("Complete.\n\nSearch Results:");
            Console.WriteLine(response);

            // Getting details about the specific EIN code
            Console.WriteLine("\n\nLoading detailed information about EIN code  \"" + TestEIN + "\"...");
            response = client.DownloadString(string.Format(EINCodeREST, TestEIN));
            Console.WriteLine("Complete.\n\nSearch Results:");
            Console.WriteLine(response);

            // Verifying the specific EIN code
            Console.WriteLine("\n\nVerifying valid existing EIN code  \"" + TestEIN + "\"...");
            response = client.DownloadString(string.Format(EINVerifyREST, TestEIN));
            Console.WriteLine("Complete.\n\nVerification Result: " + RenderEinVerificationCode(response));

            // Verifying incorrect EIN code
            Console.WriteLine("\n\nVerifying invalid EIN code  \"" + InvalidEIN + "\"...");
            response = client.DownloadString(string.Format(EINVerifyREST, InvalidEIN));
            Console.WriteLine("Complete.\n\nVerification Result: " + RenderEinVerificationCode(response));

            Console.WriteLine("\n\nPress Enter to close the window...");
            Console.ReadLine();
        }

        private static string RenderEinVerificationCode(string response)
        {
            if (response.Contains("-1"))
            {
                return "EIN is invalid";
            }
            else if (response.Contains("1"))
            {
                return "EIN was found in the database";
            }
            else if (response.Contains("2"))
            {
                return "EIN was not found in the database, but it is syntactically correct";
            }
            
            return "Unidentified response code";
        }
    }
}
